/*
 * Decompiled with CFR 0.152.
 */
package com.andavin.images;

import com.andavin.images.MapHelper;
import com.andavin.images.PacketListener;
import com.andavin.images.ProtocolLibListener;
import com.andavin.images.Versioned;
import com.andavin.images.command.CommandRegistry;
import com.andavin.images.data.DataManager;
import com.andavin.images.data.FileDataManager;
import com.andavin.images.data.MySQLDataManager;
import com.andavin.images.data.SQLiteDataManager;
import com.andavin.images.image.CustomImage;
import com.andavin.reflect.Reflection;
import com.andavin.util.LocationUtil;
import com.andavin.util.Logger;
import com.andavin.util.Scheduler;
import com.andavin.util.TimeoutMetadata;
import com.google.common.base.Preconditions;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class Images
extends JavaPlugin
implements Listener {
    private static final CustomImage[] EMPTY_IMAGES_ARRAY = new CustomImage[0];
    private boolean protocolLib;
    private static Images instance;
    private static File imagesDirectory;
    private static DataManager dataManager;
    private static final List<CustomImage> IMAGES;
    private static final Map<UUID, Long> LAST_MOVE_TIMES;
    private static final PacketListener BRIDGE;
    private static final Map<UUID, PacketListener.ImageListener> LISTENER_TASKS;

    public void onLoad() {
        instance = this;
        Logger.initialize(this.getLogger());
        imagesDirectory = this.getDataFolder();
        PacketListener.getImages = () -> IMAGES;
        Reflection.setFieldValue(Scheduler.class, null, "instance", (Object)this);
        Reflection.setFieldValue(TimeoutMetadata.class, null, "instance", (Object)this);
    }

    public void onEnable() {
        String type;
        this.saveDefaultConfig();
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this);
        Plugin protocolLib = Bukkit.getPluginManager().getPlugin("ProtocolLib");
        if (protocolLib != null) {
            this.protocolLib = true;
            Logger.info("ProtocolLib detected. Enabling generic packet handling...");
            ProtocolLibListener.register((Plugin)this, LISTENER_TASKS, BRIDGE);
        }
        FileConfiguration config = this.getConfig();
        MapHelper.invisible = config.getBoolean("invisible-frames", true);
        switch (type = config.getString("database.type").toUpperCase(Locale.ENGLISH)) {
            case "MYSQL": {
                dataManager = new MySQLDataManager(config.getString("database.host"), config.getInt("database.port"), config.getString("database.schema"), config.getString("database.user"), config.getString("database.password"));
                break;
            }
            case "SQLITE": {
                dataManager = new SQLiteDataManager(new File(imagesDirectory, "images.db"));
                break;
            }
            case "FILE": {
                dataManager = new FileDataManager(new File(imagesDirectory, "images.cimg"));
                break;
            }
            default: {
                throw new IllegalStateException("Unknown database type: " + type);
            }
        }
        if (new File(imagesDirectory, "data.yml").exists()) {
            Logger.info("Found legacy image data (1.0.x-SNAPSHOT).");
            Logger.info("Use '/images import' to import it to the new format");
        }
        if (config.getBoolean("database.initialize")) {
            dataManager.initialize();
        }
        Scheduler.laterAsync(() -> {
            IMAGES.addAll(dataManager.load());
            Logger.info("Loaded {} images...", IMAGES.size());
            CommandRegistry.registerCommands();
        }, 40L);
        Scheduler.repeatAsync(() -> {
            try {
                long now = System.currentTimeMillis();
                LAST_MOVE_TIMES.forEach((uuid, time) -> {
                    Player player;
                    if (now - time > 2500L && (player = Bukkit.getPlayer((UUID)uuid)) != null) {
                        this.refreshImages(player, player.getLocation());
                    }
                });
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                // empty catch block
            }
        }, 200L, 30L);
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        Location location = player.getLocation();
        Scheduler.laterAsync(() -> this.refreshImages(player, location), 20L);
        if (this.protocolLib) {
            return;
        }
        BRIDGE.setEntityListener(player, (clicker, image, section, action, hand) -> {
            PacketListener.ImageListener listener = LISTENER_TASKS.remove(clicker.getUniqueId());
            if (listener != null) {
                listener.click(clicker, image, section, action, hand);
            }
        });
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        Scheduler.async(() -> {
            CustomImage[] customImageArray = IMAGES;
            synchronized (IMAGES) {
                CustomImage[] images = IMAGES.toArray(EMPTY_IMAGES_ARRAY);
                // ** MonitorExit[var2_1] (shouldn't be in output)
                for (CustomImage image : images) {
                    image.remove(player, false);
                }
                return;
            }
        });
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onRespawn(PlayerRespawnEvent event) {
        Player player = event.getPlayer();
        Location location = event.getRespawnLocation();
        Scheduler.laterAsync(() -> {
            CustomImage[] customImageArray = IMAGES;
            synchronized (IMAGES) {
                CustomImage[] images = IMAGES.toArray(EMPTY_IMAGES_ARRAY);
                // ** MonitorExit[var3_2] (shouldn't be in output)
                for (CustomImage image : images) {
                    image.remove(player, true);
                    image.refresh(player, location);
                }
                return;
            }
        }, 20L);
    }

    @EventHandler
    public void onWorld(PlayerChangedWorldEvent event) {
        Player player = event.getPlayer();
        Location location = player.getLocation();
        Scheduler.laterAsync(() -> this.refreshImages(player, location), 20L);
    }

    @EventHandler
    public void onMove(PlayerMoveEvent event) {
        Location to;
        Player player = event.getPlayer();
        Location from = event.getFrom();
        if (!LocationUtil.isSameBlock(from, to = event.getTo())) {
            LAST_MOVE_TIMES.put(player.getUniqueId(), System.currentTimeMillis());
        }
        if (from.getBlockX() >> 4 != to.getBlockX() >> 4 || from.getBlockZ() >> 4 != to.getBlockZ() >> 4) {
            Scheduler.async(() -> this.refreshImages(player, to));
        }
    }

    public static Images getInstance() {
        return instance;
    }

    public static DataManager getDataManager() {
        return dataManager;
    }

    public static File getImagesDirectory() {
        return imagesDirectory;
    }

    public static List<File> getImageFiles() {
        File[] files = imagesDirectory.listFiles();
        if (files == null) {
            return Collections.emptyList();
        }
        ArrayList<File> images = new ArrayList<File>(files.length);
        for (File file : files) {
            String path;
            if (file.isDirectory() || (path = file.getPath()).endsWith(".yml") || path.endsWith(".db")) continue;
            images.add(file);
        }
        return images;
    }

    public static File getImageFile(String fileName) throws IllegalArgumentException, IllegalStateException {
        File imageFile = new File(imagesDirectory, fileName);
        if (imageFile.exists()) {
            return imageFile;
        }
        File match = null;
        File[] imageFiles = imagesDirectory.listFiles();
        Preconditions.checkState((imageFiles != null ? 1 : 0) != 0, (Object)"\u00a7cNo available images");
        for (File file : imageFiles) {
            String name = file.getName();
            if (!name.startsWith(fileName) || !file.isFile()) continue;
            if (name.lastIndexOf(46) == fileName.length() && name.length() - fileName.length() <= 5) {
                return file;
            }
            match = file;
        }
        Preconditions.checkArgument((match != null ? 1 : 0) != 0, (String)"\u00a7cImage Not Found\u00a7f %s", (Object[])new Object[]{fileName});
        return match;
    }

    public static void addListenerTask(Player player, PacketListener.ImageListener task) {
        LISTENER_TASKS.put(player.getUniqueId(), task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean addImage(CustomImage image) {
        if (IMAGES.contains(image)) {
            return false;
        }
        dataManager.save(image);
        List<CustomImage> list = IMAGES;
        synchronized (list) {
            IMAGES.add(image);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addImages(List<CustomImage> images) {
        List<CustomImage> list = IMAGES;
        synchronized (list) {
            IMAGES.addAll(images);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean removeImage(CustomImage image) {
        List<CustomImage> list = IMAGES;
        synchronized (list) {
            dataManager.delete(image);
            return IMAGES.remove(image);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<CustomImage> getMatchingImages(Predicate<CustomImage> test) {
        List<CustomImage> list = IMAGES;
        synchronized (list) {
            return IMAGES.stream().filter(test).collect(Collectors.toList());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshImages(Player player, Location location) {
        CustomImage[] customImageArray = IMAGES;
        synchronized (IMAGES) {
            CustomImage[] images = IMAGES.toArray(EMPTY_IMAGES_ARRAY);
            // ** MonitorExit[var4_3] (shouldn't be in output)
            for (CustomImage image : images) {
                image.refresh(player, location);
            }
            return;
        }
    }

    static {
        IMAGES = new ArrayList<CustomImage>();
        LAST_MOVE_TIMES = new HashMap<UUID, Long>();
        BRIDGE = Versioned.getInstance(PacketListener.class, new Object[0]);
        LISTENER_TASKS = new HashMap<UUID, PacketListener.ImageListener>(4);
    }
}

